#!/usr/local/bin/perl

#Perl/CGI Online Log Search Script by JR4PUR
#Copyleft. 21 April 2010 QSL@JR4PUR
#http://sevenpence.org/_/


# --------- Set-up ---------

#Change your call sign.
$CALLSIGN = 'JA73A';

#QSO data (You can use the UQF(asc) file As Is exported from Logger32 without changing the file. http://www.logger32.net/ )
#Please change your file name in order for QSO data not to be watched by third parties. Or, please keep the files in the other folder and make your permission of folders severely.
$QSO_DATA = "data.ASC";

#Choice of BANDS.
@BANDS = ('10', '12', '15', '17', '20', '30', '40', '80', '160');

$METER = 'm';

#Change name of data item. ( You can chose QSO data at 243rd line )
@DATA_ITEM = ('Call', 'Date', 'Band', 'Mode');

#Please use your favorite picture.
$QSO_PICT = 'CFM.png';
$NIL_PICT = 'NULL.png';

#Title
$TITLE = 'Online Log';

#Body tug
$BODY_TUG = 'body bgcolor="#ffefd5" text="#000000" link="#000000" alink="#000000" vlink="#000000" style="font-family: Times New Roman,Times,serif;"';

#Main font collor.
$FONT_COLOR = '#000000';

#You can change font collor of data names.
$CALL_COLOR = '#000000';

#You can change collor of each data item.
$ITEM_COLOR = '#ffffff';

#You can change font collor of data.
$DATA_COLOR = '#000000';

#You can change background collor of data items.
$MTB_COLOR = '#000000';

#You can change background collor of data.
$STB_COLOR = '#dcdcdc';

#You can set the maximum number of QSO data.
$RECORD = 33;

#You can change speed of blinking.
$SPEED = 630;

#You can change size of blinking area.
$SPACE = 12;

#Please change URL into your URL.
$QSY = 'http://example';

# --------- End of Set-up ---------

$QSOs = 0;

foreach $band (@BANDS){
	$usedBand{$band} = 0;
}

if ($ENV{'REQUEST_METHOD'} eq "POST"){
	read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
	}else{
	$buffer = $ENV{'QUERY_STRING'};
}

if ($buffer eq ""){
	&error('QRZ? DE',"$CALLSIGN");
}

@pairs = split(/&/,$buffer);

foreach $pair (@pairs){
	($cal,$char) = split(/=/, $pair);
	$char =~ tr/+/ /;
	$char =~ s/%([0-9A-Fa-f][0-9A-Fa-f])/pack("H2", $1 )/eg;
	$char =~ s/</&lt;/g;
	$char =~ s/>/&gt;/g;
	$char =~ s/\n//g;
	$char =~ s/\r//g;
	$char =~ s/\t//g;
	$char =~ s/\,//g;
	$form{$cal} = $char;
}

open(LOG,"$QSO_DATA") || &error('NW DATABASE QRT.. SRI PSE','QSY');

@database = <LOG>;

close(LOG);

foreach $num (0 .. $#database){
	$data = $database[$num];
	($CALL,$DATE,$UTC,$BAND,$MODE,$RST) = split(/\s+/,$data);
		next if $CALL ne uc($form{'CALL'});
			$usedBand{$BAND,$MODE} = 1;
				if ($QSOs == $RECORD){
					last;
				}else{
					push(@CFM,$data);
					++$QSOs;
				}
}

print "Content-type: text/html\n\n";
print <<"__END__";
<html>
<head>
<title>$TITLE</title>
</head>
<$BODY_TUG>
<form method=post action="search.cgi">
<b>Online Log Search for $CALLSIGN</b><br><br>
<span style=\"color: $FONT_COLOR;\"><b>Call sign : </b></span><input type=text name="CALL" size="18" maxlength="15"> <input type=submit value="Search"><br><br>
</form>
__END__

$BCALL = uc($form{'CALL'});

unless (@CFM){
	print "<span style=\"color: $FONT_COLOR;\">$BCALL : NOT in the log</span><br><br>\n";
	}else{
		print "<b><span style=\"color: $FONT_COLOR;\">$CALLSIGN Log Search Results for </span><span style=\"color: $CALL_COLOR;\">$BCALL</span></b>\n";
		print "<table>\n";
		print "<tr style=\"background:$MTB_COLOR\">\n";
		print "<th style=\"background:$MTB_COLOR\">&nbsp;</th>\n";
			foreach $band (@BANDS){
				printf "<th><span style=\"color: $ITEM_COLOR;\"><b>%s$METER</b></span></th>\n", $band;
			}
		print "</tr>\n";
# -- CW --
		print "<tr style=\"background:$STB_COLOR\">\n";
		print "<td style=\"background:$MTB_COLOR\"><center><span style=\"color: $ITEM_COLOR;\"><b>CW</b></span></center></td>\n";
			foreach $band (@BANDS){
				print "<td width='39'>\n";
					if ($usedBand{$band,CW}){
						print "<center><img src='$QSO_PICT'></center>\n";
					}else{
						print "<center><img src='$NIL_PICT'></center>\n";
					}
				print "</td>\n";
			}
		print "</tr>\n";

# -- SSB --
		print "<tr style=\"background:$STB_COLOR\">\n";
		print "<td style=\"background:$MTB_COLOR\"><center><span style=\"color: $ITEM_COLOR;\"><b>SSB</b></span></center></td>\n";
			foreach $band (@BANDS){
				print "<td width='39'>\n";
					if ($usedBand{$band,SSB}){
						print "<center><img src='$QSO_PICT'></center>\n";
					}else{
						print "<center><img src='$NIL_PICT'></center>\n";
					}
				print "</td>\n";
			}
		print "</tr>\n";

# -- RTTY --
		print "<tr style=\"background:$STB_COLOR\">\n";
		print "<td style=\"background:$MTB_COLOR\"><center><span style=\"color: $ITEM_COLOR;\"><b>RTTY</b></span></center></td>\n";
			foreach $band (@BANDS){
				print "<td width='39'>\n";
					if ($usedBand{$band,RTTY}){
						print "<center><img src='$QSO_PICT'></center>\n";
					}else{
						print "<center><img src='$NIL_PICT'></center>\n";
					}
				print "</td>\n";
			}
		print "</tr>\n";

# -- AM --
#		print "<tr style=\"background:$STB_COLOR\">\n";
#		print "<td style=\"background:$MTB_COLOR\"><center><span style=\"color: $ITEM_COLOR;\"><b>AM</b></span></center></td>\n";
#			foreach $band (@BANDS){
#				print "<td width='39'>\n";
#					if ($usedBand{$band,AM}){
#						print "<center><img src='$QSO_PICT'></center>\n";
#					}else{
#						print "<center><img src='$NIL_PICT'></center>\n";
#					}
#				print "</td>\n";
#			}
#		print "</tr>\n";

# -- FM --
#		print "<tr style=\"background:$STB_COLOR\">\n";
#		print "<td style=\"background:$MTB_COLOR\"><center><span style=\"color: $ITEM_COLOR;\"><b>FM</b></span></center></td>\n";
#			foreach $band (@BANDS){
#				print "<td width='39'>\n";
#					if ($usedBand{$band,FM}){
#						print "<center><img src='$QSO_PICT'></center>\n";
#					}else{
#						print "<center><img src='$NIL_PICT'></center>\n";
#					}
#				print "</td>\n";
#			}
#		print "</tr>\n";

# -- SSTV --
#		print "<tr style=\"background:$STB_COLOR\">\n";
#		print "<td style=\"background:$MTB_COLOR\"><center><span style=\"color: $ITEM_COLOR;\"><b>SSTV</b></span></center></td>\n";
#			foreach $band (@BANDS){
#				print "<td width='39'>\n";
#					if ($usedBand{$band,SSTV}){
#						print "<center><img src='$QSO_PICT'></center>\n";
#					}else{
#						print "<center><img src='$NIL_PICT'></center>\n";
#					}
#				print "</td>\n";
#			}
#		print "</tr>\n";

		print "</table><br>\n";
		print "<table>\n";
		print "<tr style=\"background:$MTB_COLOR\">\n";
			foreach $DATA_ITEM (@DATA_ITEM){
				printf "<th><span style=\"color: $ITEM_COLOR;\"><b>%s</b></th>\n", $DATA_ITEM;
			}
		print "</tr>\n";
			foreach $data (@CFM){
				($CALL,$DATE,$UTC,$BAND,$MODE,$RST) = split(/\s+/,$data);
				$BAND = ("$BAND$METER");
				$YY = substr($DATE, 0, 2);
					if ($YY > 45){
						$DATE =~ s/(\d\d)(\d\d)(\d\d)/19$1-$2-$3/;
					}else{
						$DATE =~ s/(\d\d)(\d\d)(\d\d)/20$1-$2-$3/;
					}
				@USE_DATA = ($CALL,$DATE,$BAND,$MODE); # -- Choice of QSO data --
				print "<tr style=\"background:$STB_COLOR\">\n";
					foreach $USE_DATA (@USE_DATA){
						printf "<td><center><span style=\"color: $DATA_COLOR;\"><b>%s</b></span></center></td>\n", $USE_DATA;
					}
				print "</tr>\n";
			}
		print "</table>\n";
		print "<b><span style=\"color: $FONT_COLOR;\">Found</span> <span style=\"color: $CALL_COLOR;\"><marquee scrolldelay=\"$SPEED\" scrollamount=\"$SPACE\" width=\"$SPACE\">$QSOs</marquee></span><span style=\"color: $FONT_COLOR;\">QSO(s)</span><br><br>\n";
		print "<span style=\"color: $MTB_COLOR;\"><i>- Perl/CGI Log Search Script by <a href=\"http://sevenpence.org/_/\">JR4PUR</a> -</i></span></b><br><br>\n";
}
print "<form action=\"onlinelog.html\"><input type=submit value=\"Clear\"></form>\n";
print "</body>\n";
print "</html>\n\n";
exit;

sub error{

print "Content-type: text/html\n\n";
print <<"__END__";
<html>
<head>
<title>$TITLE</title>
</head>
<$BODY_TUG>
$_[0] <a href=\"$QSY\">$_[1]</a>
</body>
</html>
__END__
exit;

}
